#include <solomon/libs/cpp/conf_db/model/aggregation_settings.h>

#include <library/cpp/testing/gtest/gtest.h>

#include <sstream>

using namespace NSolomon::NDb::NModel;

TEST(TAggregationSettingsTest, FromJson) {
    TString json = R"({
        "enabled": true,
        "memOnly": true,
        "aggrRules": [
            { "cond": [ "host=*" ], "target": [ "host=cluster" ], "aggr": "SUM" },
            { "cond": [ "host=*" ], "target": [ "host={{DC}}" ], "aggr": "LAST" }
        ]
    })";

    auto settings = TAggregationSettings::FromJsonStr(json);
    ASSERT_TRUE(settings.has_value());

    EXPECT_TRUE(settings->Enabled);
    EXPECT_TRUE(settings->MemOnly);

    ASSERT_EQ(settings->Rules.size(), 2u);

    const auto& rule1 = settings->Rules[0];
    EXPECT_EQ(rule1.Function, EAggregationFunction::SUM);
    EXPECT_EQ(rule1.Conditions, std::vector<TString>{"host=*"});
    EXPECT_EQ(rule1.Targets, std::vector<TString>{"host=cluster"});

    const auto& rule2 = settings->Rules[1];
    EXPECT_EQ(rule2.Function, EAggregationFunction::LAST);
    EXPECT_EQ(rule2.Conditions, std::vector<TString>{"host=*"});
    EXPECT_EQ(rule2.Targets, std::vector<TString>{"host={{DC}}"});
}

TEST(TAggregationSettingsTest, ToJson) {
    TAggregationSettings settings{
        .Rules = {
            {
                .Conditions = {"host=*"},
                .Targets = {"host=cluster"},
                .Function=EAggregationFunction::SUM
            }
        },
        .Enabled = true,
        .MemOnly = true,
    };

    auto json = settings.ToJsonStr();
    ASSERT_EQ(json, R"({"aggrRules":[{"aggr":"SUM","cond":["host=*"],"target":["host=cluster"]}],"enabled":true,"memOnly":true})");
}

TEST(TAggregationSettingsTest, ToJson_Default) {
    TAggregationSettings settings;

    auto json = settings.ToJsonStr();
    ASSERT_EQ(json, R"({"aggrRules":[],"enabled":false,"memOnly":false})");
}
