#pragma once

#include <solomon/libs/cpp/actors/events/events.h>
#include <solomon/libs/cpp/actors/events/slots.h>
#include <solomon/libs/cpp/conf_db/model/shard_config.h>
#include <solomon/libs/cpp/conf_db/table_loader/table_loader.h>
#include <solomon/libs/cpp/conf_db/ydb/dao.h>

#include <library/cpp/actors/core/actor.h>
#include <library/cpp/actors/core/event_local.h>
#include <library/cpp/monlib/metrics/metric_registry.h>

namespace NSolomon {

struct TConfigs {
    bool Empty() const {
        return Projects.empty() &&
               Services.empty() &&
               Clusters.empty() &&
               Shards.empty() &&
               Agents.empty() &&
               Providers.empty();
    }

    TVector<NDb::NModel::TProjectConfig> Projects;
    TVector<NDb::NModel::TServiceConfig> Services;
    TVector<NDb::NModel::TClusterConfig> Clusters;
    TVector<NDb::NModel::TShardConfig> Shards;
    TVector<NDb::NModel::TAgentConfig> Agents;
    TVector<NDb::NModel::TProviderConfig> Providers;

    Y_SAVELOAD_DEFINE(Projects, Services, Clusters, Shards, Agents, Providers);
};

struct TConfigsPullerOptions {
    NDb::IProjectConfigDaoPtr ProjectDao;
    NDb::IClusterConfigDaoPtr ClusterDao;
    NDb::IServiceConfigDaoPtr ServiceDao;
    NDb::IShardConfigDaoPtr ShardDao;
    NDb::IAgentConfigDaoPtr AgentDao;
    NDb::IProviderConfigDaoPtr ProviderDao;
    TDuration UpdateInterval;
    TDuration MaxUpdateInterval;
    NMonitoring::IMetricRegistry& Registry;
    const TConfigs& ConfigsForTesting = {};
};

struct TConfigsPullerEvents: private TEventSlot<EEventSpace::Libs, ELibSlot::ConfigsPuller> {
    enum {
        Subscribe = SpaceBegin,
        ShardsResponse,
        End,
    };
    static_assert(End < SpaceEnd, "too many events");

    struct TSubscribe: public NActors::TEventLocal<TSubscribe, Subscribe> {
    };

    struct TConfigsResponse: public NActors::TEventLocal<TConfigsResponse, ShardsResponse> {
        TConfigs Configs;

        explicit TConfigsResponse(TConfigs configs)
            : Configs{std::move(configs)}
        {
        }
    };
};

std::unique_ptr<NActors::IActor> CreateConfigsPuller(TConfigsPullerOptions options);

} // namespace NSolomon
