#pragma once

#include <solomon/libs/cpp/actors/events/events.h>
#include <solomon/libs/cpp/actors/events/slots.h>
#include <solomon/libs/cpp/error_or/error_or.h>

#include <solomon/libs/cpp/conf_db/db.h>
#include <solomon/libs/cpp/conf_db/model/agent_config.h>
#include <solomon/libs/cpp/conf_db/model/cluster_config.h>
#include <solomon/libs/cpp/conf_db/model/project_config.h>
#include <solomon/libs/cpp/conf_db/model/provider_config.h>
#include <solomon/libs/cpp/conf_db/model/service_config.h>
#include <solomon/libs/cpp/conf_db/model/shard_config.h>
#include <solomon/libs/cpp/ydb/config/ydb_config.pb.h>

#include <library/cpp/actors/core/actor.h>
#include <library/cpp/actors/core/events.h>
#include <library/cpp/actors/core/event_local.h>
#include <library/cpp/monlib/metrics/fwd.h>
#include <library/cpp/monlib/metrics/labels.h>

namespace NSolomon::NTableLoader {

struct TTableLoaderEvents: private TEventSlot<EEventSpace::Libs, ELibSlot::TableLoader> {
    enum {
        EvLoadRequest = SpaceBegin,
        EvLoadShardsReady,
        EvLoadClustersReady,
        EvLoadServicesReady,
        EvLoadProjectsReady,
        EvLoadAgentsReady,
        EvLoadProvidersReady,
        End,
    };
    static_assert(End < SpaceEnd, "too many event types");
};

template <typename TModel>
using TLoadResult = TErrorOr<TVector<TModel>, TGenericError>;

template <typename TEv, ui32 EvType, typename TModel>
struct TEvSomethingReady: NActors::TEventLocal<TEv, EvType> {
    TEvSomethingReady(TVector<TModel> shards)
        : Result{decltype(Result)::FromValue(std::move(shards))}
    {
    }

    TEvSomethingReady(TString error)
        : Result{decltype(Result)::FromError(std::move(error))}
    {
    }

    TLoadResult<TModel> Result;
};

struct TEvShardsReady
    : TEvSomethingReady<TEvShardsReady, TTableLoaderEvents::EvLoadShardsReady, NDb::NModel::TShardConfig> {
    DEFINE_SIMPLE_LOCAL_EVENT(TEvShardsReady, "TEvShardsReady");
    using TBase = TEvSomethingReady<TEvShardsReady, TTableLoaderEvents::EvLoadShardsReady, NDb::NModel::TShardConfig>;
    using TBase::TBase;
};

struct TEvClustersReady
    : TEvSomethingReady<TEvClustersReady, TTableLoaderEvents::EvLoadClustersReady, NDb::NModel::TClusterConfig> {
    DEFINE_SIMPLE_LOCAL_EVENT(TEvClustersReady, "TEvClustersReady");
    using TBase =
        TEvSomethingReady<TEvClustersReady, TTableLoaderEvents::EvLoadClustersReady, NDb::NModel::TClusterConfig>;
    using TBase::TBase;
};

struct TEvServicesReady
    : TEvSomethingReady<TEvServicesReady, TTableLoaderEvents::EvLoadServicesReady, NDb::NModel::TServiceConfig> {
    DEFINE_SIMPLE_LOCAL_EVENT(TEvServicesReady, "TEvServicesReady");
    using TBase =
        TEvSomethingReady<TEvServicesReady, TTableLoaderEvents::EvLoadServicesReady, NDb::NModel::TServiceConfig>;
    using TBase::TBase;
};

struct TEvProjectsReady
    : TEvSomethingReady<TEvProjectsReady, TTableLoaderEvents::EvLoadProjectsReady, NDb::NModel::TProjectConfig> {
    DEFINE_SIMPLE_LOCAL_EVENT(TEvProjectsReady, "TEvProjectsReady");
    using TBase =
        TEvSomethingReady<TEvProjectsReady, TTableLoaderEvents::EvLoadProjectsReady, NDb::NModel::TProjectConfig>;
    using TBase::TBase;
};

struct TEvAgentsReady
    : TEvSomethingReady<TEvAgentsReady, TTableLoaderEvents::EvLoadAgentsReady, NDb::NModel::TAgentConfig> {
    DEFINE_SIMPLE_LOCAL_EVENT(TEvAgentsReady, "TEvAgentsReady");
    using TBase = TEvSomethingReady<TEvAgentsReady, TTableLoaderEvents::EvLoadAgentsReady, NDb::NModel::TAgentConfig>;
    using TBase::TBase;
};

struct TEvProvidersReady
    : TEvSomethingReady<TEvProvidersReady, TTableLoaderEvents::EvLoadProvidersReady, NDb::NModel::TProviderConfig>
{
    DEFINE_SIMPLE_LOCAL_EVENT(TEvProvidersReady, "TEvProvidersReady");
    using TBase = TEvSomethingReady<TEvProvidersReady, TTableLoaderEvents::EvLoadProvidersReady, NDb::NModel::TProviderConfig>;
    using TBase::TBase;
};

struct TShardLoaderConfig {
    TShardLoaderConfig(NMonitoring::IMetricRegistry& registry)
        : Metrics{registry}
    {
    }

    NMonitoring::IMetricRegistry& Metrics;
};

struct TClusterLoaderConfig {
    TClusterLoaderConfig(NMonitoring::IMetricRegistry& registry)
        : Metrics{registry}
    {
    }

    NMonitoring::IMetricRegistry& Metrics;
};

struct TServiceLoaderConfig {
    TServiceLoaderConfig(NMonitoring::IMetricRegistry& registry)
        : Metrics{registry}
    {
    }

    NMonitoring::IMetricRegistry& Metrics;
};

struct TProjectLoaderConfig {
    TProjectLoaderConfig(NMonitoring::IMetricRegistry& registry)
        : Metrics{registry}
    {
    }

    NMonitoring::IMetricRegistry& Metrics;
};

struct TAgentLoaderConfig {
    TAgentLoaderConfig(NMonitoring::IMetricRegistry& registry)
        : Metrics{registry}
    {
    }

    NMonitoring::IMetricRegistry& Metrics;
};

struct TProviderLoaderConfig {
    TProviderLoaderConfig(NMonitoring::IMetricRegistry& registry)
        : Metrics{registry}
    {
    }

    NMonitoring::IMetricRegistry& Metrics;
};

NActors::IActor* CreateShardLoaderActor(NDb::IShardConfigDaoPtr shardDao, TShardLoaderConfig config, NActors::TActorId receiver);
NActors::IActor* CreateClusterLoaderActor(NDb::IClusterConfigDaoPtr clusterDao, TClusterLoaderConfig config, NActors::TActorId receiver);
NActors::IActor* CreateServiceLoaderActor(NDb::IServiceConfigDaoPtr serviceDao, TServiceLoaderConfig config, NActors::TActorId receiver);
NActors::IActor* CreateProjectLoaderActor(NDb::IProjectConfigDaoPtr projectDao, TProjectLoaderConfig config, NActors::TActorId receiver);
NActors::IActor* CreateAgentsLoaderActor(NDb::IAgentConfigDaoPtr agentDao, TAgentLoaderConfig config, NActors::TActorId receiver);
NActors::IActor* CreateProvidersLoaderActor(NDb::IProviderConfigDaoPtr providerDao, TProviderLoaderConfig config, NActors::TActorId receiver);

} // namespace NSolomon::NTableLoader
