#pragma once

#include <solomon/libs/cpp/conf_db/db.h>

#include <ydb/public/sdk/cpp/client/ydb_table/table.h>

#include <library/cpp/monlib/metrics/fwd.h>

namespace NSolomon::NDb {

IClusterConfigDaoPtr CreateYdbClusterDao(const TString& path, std::shared_ptr<NYdb::NTable::TTableClient> client, NMonitoring::TMetricRegistry& registry);
IShardConfigDaoPtr CreateYdbShardDao(const TShardTables& tables, std::shared_ptr<NYdb::NTable::TTableClient> client, NMonitoring::TMetricRegistry& registry);
IServiceConfigDaoPtr CreateYdbServiceDao(TString path, std::shared_ptr<NYdb::NTable::TTableClient> client, NMonitoring::TMetricRegistry& registry);
IAgentConfigDaoPtr CreateYdbAgentDao(const TString& path, std::shared_ptr<NYdb::NTable::TTableClient> client, NMonitoring::TMetricRegistry& registry);
IProjectConfigDaoPtr CreateYdbProjectDao(TString path, std::shared_ptr<NYdb::NTable::TTableClient> client, NMonitoring::TMetricRegistry& registry);
IProviderConfigDaoPtr CreateYdbProviderDao(TString path, std::shared_ptr<NYdb::NTable::TTableClient> client, NMonitoring::TMetricRegistry& registry);

} // namespace NSolomon::NDb
