#pragma once

#include <solomon/libs/cpp/ydb/parser.h>
#include <solomon/libs/cpp/conf_db/model/shard_settings.h>

namespace NSolomon::NDb {

template <typename TModel>
class TShardSettingsFieldParser: public IFieldParser<TModel> {
public:
    TShardSettingsFieldParser(NYdb::TResultSetParser& parser, NModel::TShardSettings TModel::* field, TString column)
        : Parser_{parser}
        , Field_{field}
        , Column_{std::move(column)}
    {
    }

    void LoadOpt(TModel& model) override {
        if (auto value = Parser_.ColumnParser(Column_).GetOptionalUtf8()) {
            if (auto settings = NModel::TShardSettings::FromJsonStr(*value)) {
                (model.*Field_) = std::move(*settings);
            }
        }
    }

private:
    NYdb::TResultSetParser& Parser_;
    NModel::TShardSettings TModel::* Field_;
    const TString Column_;
};

template <typename TModel>
auto ShardSettingsFieldParser(NYdb::TResultSetParser& parser, NModel::TShardSettings TModel::*field, TString column) {
    return MakeHolder<TShardSettingsFieldParser<TModel>>(parser, field, std::move(column));
}

} // namespace NSolomon::NDb
