#include "config_creators.h"

#include <util/random/random.h>

using namespace NSolomon::NDb::NModel;

namespace NSolomon::NTesting {
    TClusterConfig MakeClusterConfig() {
        TClusterConfig model;
        model.Id = "my-cluster-id";
        model.Name = "foobar";
        model.ProjectId = "test-project";
        model.Hosts = "some.hosts";
        model.HostUrls = "some.urls";
        model.ConductorGroups = "conductor-group";
        model.ConductorTags = "conductor-tags";
        model.NannyGroups = "nanny-group";
        model.QloudGroups = "qloud-group";
        model.Networks = "networks";
        model.YpClusters = "yp-clusters";
        model.Description = "test description";
        model.ShardSettings = {};
        model.CreatedAt = TInstant::Seconds(100501);
        model.UpdatedAt = TInstant::Seconds(100505);
        model.CreatedBy = "me";
        model.UpdatedBy = "someone";
        model.Version = 42;
        model.Labels = "";

        return model;
    }

    TShardConfig MakeShardConfig() {
        TShardConfig model;

        model.Id = "my-shard-id";
        model.NumId = RandomNumber<ui32>();
        model.ClusterId = "my-cluster-id";
        model.ClusterName = "my-cluster-name";
        model.CreatedAt = TInstant::Seconds(2);
        model.CreatedBy = "some-user";
        model.MaxFileMetrics = 85;
        model.MaxMemMetrics = 34;
        model.MaxResponseSizeBytes = 100;
        model.MaxMetricsPerUrl = 40;
        model.ValidationMode = "strictFail";
        model.ProjectId = "test-project";
        model.ServiceId = "my-service-id";
        model.ServiceName = "test-service";
        model.Description = "test description";
        model.ShardSettings = {};
        model.State = ::FromString<EShardState>("ACTIVE");
        model.UpdatedAt = TInstant::Seconds(5);
        model.UpdatedBy = "some-other-user";
        model.Version = 43;
        model.Labels = "";

        return model;
    }

    TServiceConfig MakeServiceConfig() {
        TServiceConfig model;

        model.Id = "my-service-id";
        model.Version = 48;
        model.CreatedAt = TInstant::Seconds(42);
        model.CreatedBy = "user1";
        model.Interval = TDuration::Seconds(14);
        model.GridSec = 30;
        model.Name = "test-service";
        model.ProjectId = "test-project";
        model.MetricConf = TMetricConf::FromString(METRIC_CONF_TEST_DATA);
        model.Description = "test description";
        model.ShardSettings = {
                .PullOrPush = TPullSettings{
                    .Port = 1337,
                    .Path = "/service/path",
                    .AddTsArgs = true,
                    .Protocol = EPullProtocol::HTTP,
                },
        };
        model.UpdatedAt = TInstant::Days(2);
        model.UpdatedBy = "user2";
        model.Labels = "";

        return model;
    };

    TAgentConfig MakeAgentConfig() {
        TAgentConfig model;

        model.Hostname = "host1.solomon";
        model.DataPort = 3;
        model.ManagementPort = 5;
        model.Provider = "provider";
        model.Version = "bleedingEdge";
        model.LastSeen = TInstant::Seconds(42);
        model.Description = "This is my agent";
        model.PullInterval = TDuration::Seconds(14);
        model.DataPort = 3443;
        model.ManagementPort = 1221;

        return model;
    }

    TProjectConfig MakeProjectConfig() {
        TProjectConfig model;
        model.Id = "test-project";
        model.Name = "baz";
        model.Description = "description";
        model.Owner = "bar";
        model.AbcService = "foo";
        model.CreatedAt = TInstant::Seconds(4);
        model.CreatedBy = "someoneelse";
        model.UpdatedAt = TInstant::Seconds(54);
        model.UpdatedBy = "someone";
        model.DeleteAcl = "deleteAcl";
        model.UpdateAcl = "updateAcl";
        model.ReadAcl = "readAcl";
        model.WriteAcl = "writeAcl";
        model.Version = 83;
        model.OnlyAuthPush = true;
        model.OnlyAuthRead = true;
        model.OnlyMetricNameShards = true;
        model.OnlyNewFormatWrites = true;
        model.OnlyNewFormatReads = true;
        model.MetricNameLabel = "";
        model.Labels = "";

        return model;
    }

    TProviderConfig MakeProviderConfig() {
        TProviderConfig model;

        model.Id = "test-provider";
        model.Description = "test provider";
        model.ShardSettings = TProviderShardSettings::FromString(SHARD_SETTINGS_TEST_DATA);
        model.AbcService = "test";
        model.CloudId = "a123bcdef";
        model.TvmDestId = "666666";
        model.IamServiceAccountIds = {"sa123bcdef", "a087ads89a"};
        model.CreatedAt = TInstant::Seconds(4);
        model.UpdatedAt = TInstant::Seconds(54);
        model.CreatedBy = "someone";
        model.UpdatedBy = "someoneelse";
        model.Version = 83;
        model.References = {
            {
                .Label = "label1",
            },
            {
                .Label = "label2",
            },
        };

        return model;
    }
}
