#pragma once

#include <solomon/libs/cpp/conf_db/model/agent_config.h>
#include <solomon/libs/cpp/conf_db/model/cluster_config.h>
#include <solomon/libs/cpp/conf_db/model/project_config.h>
#include <solomon/libs/cpp/conf_db/model/provider_config.h>
#include <solomon/libs/cpp/conf_db/model/service_config.h>
#include <solomon/libs/cpp/conf_db/model/shard_config.h>
#include <solomon/libs/cpp/conf_db/model/shard_state.h>

#include <util/string/cast.h>

using namespace NSolomon::NDb::NModel;

namespace NSolomon::NTesting {
    const TString METRIC_CONF_TEST_DATA =
        R"({"aggrRules":[{"cond":["dc=sas"],"target":["host=cluster_sas"]},{"cond":["dc=man"],"target":["host=cluster_man"]},{"cond":["host=*"],"target":["host=cluster"]}],"rawDataMemOnly":true})";

    const TString SHARD_SETTINGS_TEST_DATA =
            TString{R"({"grid":15,"interval":30,"metricTtlDays":30,"metricConf":)"} + METRIC_CONF_TEST_DATA + "}";

    TClusterConfig MakeClusterConfig();
    TShardConfig MakeShardConfig();
    TServiceConfig MakeServiceConfig();
    TProjectConfig MakeProjectConfig();
    TAgentConfig MakeAgentConfig();
    TProviderConfig MakeProviderConfig();
}
