LIBRARY()

OWNER(g:solomon)

SRCS(
    ydb.cpp
    cluster_dao.cpp
    shard_dao.cpp
    service_dao.cpp
    project_dao.cpp
    provider_dao.cpp
    agent_dao.cpp
)

PEERDIR(
    library/cpp/resource
    solomon/libs/cpp/conf_db/model
    solomon/libs/cpp/ydb
    solomon/libs/cpp/ydb/config
    ydb/public/sdk/cpp/client/ydb_driver
    ydb/public/sdk/cpp/client/ydb_result
    ydb/public/sdk/cpp/client/ydb_table
)

RESOURCE(
    # XXX: java does not support resources that are located outside of project tree
    solomon/libs/java/conf-db/src/db/dao/kikimr/cluster_create_table.yql cluster_create_table.yql
    solomon/libs/java/conf-db/src/db/dao/kikimr/cluster_find_for_project.yql cluster_find_for_project.yql
    solomon/libs/java/conf-db/src/db/dao/kikimr/cluster_find.yql cluster_find.yql
    solomon/libs/java/conf-db/src/db/dao/kikimr/cluster_find_by_name.yql cluster_find_by_name.yql
    solomon/libs/java/conf-db/src/db/dao/kikimr/cluster_insert.yql cluster_insert.yql
    solomon/libs/java/conf-db/src/db/dao/kikimr/cluster_delete.yql cluster_delete.yql
    solomon/libs/java/conf-db/src/db/dao/kikimr/shard_insert.yql shard_insert.yql
    solomon/libs/java/conf-db/src/db/dao/kikimr/shard_create_table.yql shard_create_table.yql
    solomon/libs/java/conf-db/src/db/dao/kikimr/shard_delete_with_project.yql shard_delete_with_project.yql
    solomon/libs/java/conf-db/src/db/dao/kikimr/shard_find_with_project.yql shard_find_with_project.yql
    solomon/libs/java/conf-db/src/db/dao/kikimr/service_create_table.yql service_create_table.yql
    solomon/libs/java/conf-db/src/db/dao/kikimr/service_find_with_project.yql service_find_with_project.yql
    solomon/libs/java/conf-db/src/db/dao/kikimr/service_find_by_name.yql service_find_by_name.yql
    solomon/libs/java/conf-db/src/db/dao/kikimr/service_delete_for_project.yql service_delete_for_project.yql
    solomon/libs/java/conf-db/src/db/dao/kikimr/service_delete_with_project.yql service_delete_with_project.yql
    solomon/libs/java/conf-db/src/db/dao/kikimr/service_insert.yql service_insert.yql
    solomon/libs/java/conf-db/src/db/dao/kikimr/agent_create_table.yql agent_create_table.yql
    solomon/libs/java/conf-db/src/db/dao/kikimr/agent_delete_for_provider.yql agent_delete_for_provider.yql
    solomon/libs/java/conf-db/src/db/dao/kikimr/agent_insert.yql agent_insert.yql
    solomon/libs/java/conf-db/src/db/dao/kikimr/agent_delete.yql agent_delete.yql
    solomon/libs/java/conf-db/src/db/dao/kikimr/agent_delete_obsolete.yql agent_delete_obsolete.yql
    solomon/libs/java/conf-db/src/db/dao/kikimr/project_insert.yql project_insert.yql
    solomon/libs/java/conf-db/src/db/dao/kikimr/project_delete.yql project_delete.yql
    solomon/libs/java/conf-db/src/db/dao/kikimr/project_create_table.yql project_create_table.yql
    solomon/libs/java/conf-db/src/db/dao/kikimr/project_exists.yql project_exists.yql
    solomon/libs/java/conf-db/src/db/dao/kikimr/project_find.yql project_find.yql
    solomon/libs/java/conf-db/src/db/dao/kikimr/service_provider_insert.yql service_provider_insert.yql
    solomon/libs/java/conf-db/src/db/dao/kikimr/service_provider_delete.yql service_provider_delete.yql
    solomon/libs/java/conf-db/src/db/dao/kikimr/service_provider_create_table.yql service_provider_create_table.yql
    solomon/libs/java/conf-db/src/db/dao/kikimr/service_provider_exists.yql service_provider_exists.yql
    solomon/libs/java/conf-db/src/db/dao/kikimr/service_provider_find.yql service_provider_find.yql
)

END()
