#include "units.h"

namespace NSolomon {
    using namespace yandex::solomon::config;

    TDuration FromProtoTime(const yandex::solomon::config::Time& t, TDuration defaultDuration) {
        if (t.value() == 0) {
            return defaultDuration;
        }

        switch (t.GetUnit()) {
            case NANOSECONDS:
                Y_FAIL("nanosecond resolution is not supported");
            case MICROSECONDS:
                return TDuration::MicroSeconds(t.GetValue());
            case MILLISECONDS:
                return TDuration::MilliSeconds(t.GetValue());
            case SECONDS:
                return TDuration::Seconds(t.GetValue());
            case MINUTES:
                return TDuration::Minutes(t.GetValue());
            case HOURS:
                return TDuration::Hours(t.GetValue());
            case DAYS:
                return TDuration::Days(t.GetValue());
            default:
                Y_FAIL("unsupported time unit: %s", TimeUnit_Name(t.GetUnit()).c_str());
        }
    }

    ui64 FromProtoDataSize(const yandex::solomon::config::DataSize& ds) {
        switch (ds.GetUnit()) {
            case BYTES:
                return ds.GetValue();
            case KILOBYTES:
                return ds.GetValue() * 1024;
            case MEGABYTES:
                return ds.GetValue() * 1024 * 1024;
            case GIGABYTES:
                return ds.GetValue() * 1024 * 1024 * 1024;
            default:
                Y_FAIL("unsupported data size unit: %s", DataUnit_Name(ds.GetUnit()).c_str());
        };
    }
} // namespace NSolomon
