#include <solomon/libs/cpp/config/units.h>

#include <library/cpp/testing/gtest/gtest.h>

using namespace NSolomon;
using namespace yandex::solomon::config;

TEST(ProtoTimeWithoutDefault, HappyPath) {
    Time t;
    t.SetUnit(TimeUnit::SECONDS);
    t.SetValue(123);

    auto d = FromProtoTime(t);
    EXPECT_EQ(d, TDuration::Seconds(123));
}

TEST(ProtoTimeWithoutDefault, EmptyTime) {
    Time t;
    auto d = FromProtoTime(t);

    EXPECT_EQ(d, TDuration::Zero());
}

TEST(ProtoTimeWithDefault, NotEmpty) {
    Time t;
    t.SetUnit(TimeUnit::MILLISECONDS);
    t.SetValue(45);

    auto d = FromProtoTime(t, TDuration::Hours(666));
    EXPECT_EQ(d, TDuration::MilliSeconds(45));
}

TEST(ProtoTimeWithDefault, Empty) {
    Time t;

    auto d = FromProtoTime(t, TDuration::Hours(666));
    EXPECT_EQ(d, TDuration::Hours(666));
}
