#include "config_includes.h"

#include <google/protobuf/message.h>
#include <google/protobuf/descriptor.h>
#include <google/protobuf/reflection.h>

#include <google/protobuf/text_format.h>

#include <util/stream/file.h>

namespace NSolomon {
    using namespace google::protobuf;

    void MergeIncludes(Message& message) {
        const auto* descriptor = message.GetDescriptor();
        const FieldDescriptor* fieldDescriptor{nullptr};
        for (auto s: {"Include", "include"}) {
            fieldDescriptor = descriptor->FindFieldByName(s);
            if (fieldDescriptor) {
                break;
            }
        }

        if (fieldDescriptor == nullptr || !fieldDescriptor->is_repeated() || fieldDescriptor->type() != FieldDescriptor::TYPE_STRING) {
            return;
        }

        const auto* reflection = message.GetReflection();
        const auto count = reflection->FieldSize(message, fieldDescriptor);

        for (auto i = 0; i < count; ++i) {
            auto includePath = reflection->GetRepeatedString(message, fieldDescriptor, i);
            TFileInput in{includePath};
            TextFormat::MergeFromString(in.ReadAll(), &message);
        }
    }
} // namespace NSolomon
