#pragma once

#include <solomon/libs/cpp/actors/fwd.h>
#include <solomon/libs/cpp/distributed_lock/lock.h>

#include <util/generic/ptr.h>

namespace NSolomon::NCoordination {
    class IClusterMember {
    public:
        virtual ~IClusterMember() = default;
        virtual void OnBecomeLeader() = 0;
        virtual void OnBecomeFollower() = 0;

        virtual void OnLeaderChanged(TString leaderId, ui64 orderId) = 0;
        virtual void OnError(const TString& errorMsg) = 0;
    };

    NActors::IActor* CreateClusterMemberActor(
        IDistributedLockPtr lock,
        THolder<IClusterMember> impl,
        TDuration reconnectTimeout = TDuration::Seconds(5)
    );
} // namespace NSolomon::NCoordination
