#include "counters.h"

#include <library/cpp/monlib/metrics/metric_registry.h>

using namespace NMonitoring;

namespace NSolomon::NCoordination {
    TBalancerCounters::TBalancerCounters(NMonitoring::IMetricFactory& factory)
        : IsLeader_{factory.IntGauge(NMonitoring::MakeLabels({{"sensor", "balancer.isLeader"}}))}
        , IsOnline_{factory.IntGauge(NMonitoring::MakeLabels({{"sensor", "balancer.isOnline"}}))}
        , OnlineNodes_{factory.IntGauge(NMonitoring::MakeLabels({{"sensor", "balancer.nodesOnline"}}))}
        , TotalNodes_{factory.IntGauge(NMonitoring::MakeLabels({{"sensor", "balancer.nodesTotal"}}))}
        , AssignmentAge_{factory.IntGauge(NMonitoring::MakeLabels({{"sensor", "balancer.assignmentAgeSeconds"}}))}
        , OrderId_{factory.Gauge(NMonitoring::MakeLabels({{"sensor", "balancer.leaderOrderId"}}))}
    {
    }

    void TBalancerCounters::SetLeader() {
        IsLeader_->Set(1);
    }

    void TBalancerCounters::UnsetLeader() {
        IsLeader_->Set(0);
    }

    void TBalancerCounters::Suspend() {
        IsOnline_->Set(0);
    }

    void TBalancerCounters::Resume() {
        IsOnline_->Set(1);
    }

    void TBalancerCounters::SetOnlineNodes(ui32 count) {
        OnlineNodes_->Set(count);
    }

    void TBalancerCounters::SetTotalNodes(ui32 count) {
        TotalNodes_->Set(count);
    }

    void TBalancerCounters::SetAssignmentAgeSeconds(ui32 val) {
        AssignmentAge_->Set(val);
    }

    void TBalancerCounters::SetLeaderOrderId(ui64 orderId) {
        OrderId_->Set(orderId);
    }
} // namespace NSolomon::NCoordiantion
