#pragma once

#include <library/cpp/monlib/metrics/fwd.h>

#include <util/system/types.h>

namespace NSolomon::NCoordination {
    class TBalancerCounters {
    public:
        TBalancerCounters(NMonitoring::IMetricFactory& factory);

        void SetLeader();
        void UnsetLeader();

        void SetOnlineNodes(ui32 count);
        void SetTotalNodes(ui32 count);

        void Suspend();
        void Resume();

        void SetAssignmentAgeSeconds(ui32 val);
        void SetLeaderOrderId(ui64 orderId);

    private:
        NMonitoring::IIntGauge* IsLeader_{};
        NMonitoring::IIntGauge* IsOnline_{};
        NMonitoring::IIntGauge* OnlineNodes_{};
        NMonitoring::IIntGauge* TotalNodes_{};
        NMonitoring::IIntGauge* AssignmentAge_{};
        NMonitoring::IGauge* OrderId_;
    };
} // namespace NSolomon::NCoordination
