#pragma once

#include "cluster_state.h"
#include "load_balancer_state.h"

#include <solomon/libs/cpp/actors/events/events.h>
#include <solomon/libs/cpp/actors/events/slots.h>

#include <library/cpp/actors/core/events.h>

namespace NSolomon::NCoordination {
    using TSlice = std::pair<ui64, ui64>;
    using TSlices = TVector<TSlice>;

    class TAssignments {
    public:
        TAssignments(TNodeId nodeId, TSlices slices)
            : NodeId_{nodeId}
            , Slices_{std::move(slices)}
        {
        }

        TNodeId NodeId() const {
            return NodeId_;
        }

        const TSlices& Slices() const {
            return Slices_;
        }

        static TAssignments EmptyAssignments(TNodeId nodeId) {
            return TAssignments{nodeId, {}};
        }

    private:
        TNodeId NodeId_;
        TSlices Slices_;
    };

    inline bool operator==(const TAssignments& lhs, const TAssignments& rhs) {
        return lhs.NodeId() == rhs.NodeId()
            && lhs.Slices() == rhs.Slices();
    }

    inline IOutputStream& operator<<(IOutputStream& os, const TAssignments& assn) {
        os << "Node: " << assn.NodeId() << '\n';
        for (auto&& s: assn.Slices()) {
            os << s.first << '-' << s.second << '\n';
        }

        return os;
    }

    struct TLoadBalancerEvents: private TEventSlot<EEventSpace::Libs, ELibSlot::LoadBalancer> {
        enum {
            EvAssignment = SpaceBegin,

            EvSuspend,
            EvResume,

            EvDescribeRequest,
            EvDescribeResponse,
            End,
        };
        static_assert(End < SpaceEnd, "too many event types");

        struct TEvAssignment: public NActors::TEventLocal<TEvAssignment, EvAssignment> {
            TEvAssignment(TAssignments assn)
                : Assignment{std::move(assn)}
            {
            }

            TAssignments Assignment;
        };

        struct TEvDescribeRequest: public NActors::TEventLocal<TEvDescribeRequest, EvDescribeRequest> {
            TEvDescribeRequest() = default;
        };

        struct TEvDescribeResponse: public NActors::TEventLocal<TEvDescribeResponse, EvDescribeResponse> {
            TEvDescribeResponse(ELoadBalancerState balancerState, TClusterState clusterState, TAssignments assignments)
                : ClusterState{std::move(clusterState)}
                , CurrentAssignments{std::move(assignments)}
                , BalancerState{balancerState}
            {
            }

            TClusterState ClusterState;
            TAssignments CurrentAssignments;
            ELoadBalancerState BalancerState;
        };

        struct TEvSuspend: public NActors::TEventLocal<TEvSuspend, EvSuspend> {
        };

        struct TEvResume: public NActors::TEventLocal<TEvResume, EvResume> {
        };
    };
} // namespace NSolomon::NCoordination
