#pragma once

#include "cluster_state.h"
#include "events.h"

#include <solomon/libs/cpp/actors/fwd.h>
#include <solomon/libs/cpp/distributed_lock/lock.h>

#include <library/cpp/actors/core/event_local.h>
#include <library/cpp/monlib/metrics/fwd.h>

#include <util/datetime/base.h>
#include <util/generic/ptr.h>

namespace NSolomon::NCoordination {
    struct ILoadBalancingStrategy {
        virtual ~ILoadBalancingStrategy() = default;
        virtual TVector<TAssignments> MakeAssignments(TVector<TNodeState> load) noexcept = 0;
    };

    using ILoadBalancingStrategyPtr = THolder<ILoadBalancingStrategy>;

    struct TLoadBalancerConfig {
        NMonitoring::IMetricFactory& MetricFactory;
        TDuration PingInterval{TDuration::Seconds(5)};
        TDuration OfflineThreshold{TDuration::Seconds(30)};
    };

    NActors::IActor* CreateLoadBalancerActor(
        ILoadBalancingStrategyPtr balancingStrategy,
        IDistributedLockPtr lock,
        TLoadBalancerConfig config
    );

    // shardCount must be a power of two
    ILoadBalancingStrategyPtr CreateStaticBalancer(ui32 shardCount = 128);
    NActors::TActorId MakeLoadBalancerId(ui32 nodeId = 0);
} // namespace NSolomon::NCoordination
