#include "private_events.h"
#include "events.h"

namespace NSolomon::NCoordination {
    TAssignments AssignmentsFromProto(const NProto::TEvAssignment& proto) {
        auto nodeId = proto.GetNodeId();
        TSlices slices;

        for (auto slice: proto.GetSlices()) {
            slices.emplace_back(slice.GetBegin(), slice.GetEnd());
        }

        return TAssignments{std::move(nodeId), std::move(slices)};
    }

    THolder<TLoadBalancerPrivate::TEvAssignment> AssignmentsToProto(TAssignments& assignments, TNodeId nodeId, ui64 orderId) {
        auto ev = MakeHolder<TLoadBalancerPrivate::TEvAssignment>();
        ev->Record.SetNodeId(nodeId);
        ev->Record.SetOrderId(orderId);

        for (auto&& slice: assignments.Slices()) {
            auto* protoSlice = ev->Record.AddSlices();
            protoSlice->SetBegin(slice.first);
            protoSlice->SetEnd(slice.second);
        }

        return ev;
    }
} // namespace NSolomon::NCoordination
