#pragma once

#include "cluster_state.h"

#include <solomon/libs/cpp/actors/events/events.h>
#include <solomon/libs/cpp/coordination/load_balancer/proto/load_balancer.pb.h>

#include <library/cpp/actors/core/event_pb.h>
#include <library/cpp/actors/core/events.h>

namespace NSolomon::NCoordination {
    struct TLoadBalancerPrivate: private TPrivateEvents {
        enum {
            EvAssignment = SpaceBegin,
            EvNodeInfo,
            End,
        };
        static_assert(End < SpaceEnd, "too many event types");

        struct TEvAssignment: public NActors::TEventPB<TEvAssignment, NProto::TEvAssignment, EvAssignment> {
        };

        struct TEvNodeInfo: public NActors::TEventPB<TEvNodeInfo, NProto::TEvNodeInfo, EvNodeInfo> {
        };
    };

    class TAssignments;
    TAssignments AssignmentsFromProto(const NProto::TEvAssignment& proto);
    THolder<TLoadBalancerPrivate::TEvAssignment> AssignmentsToProto(TAssignments& assignments, TNodeId nodeId, ui64 orderId);
} // namespace NSolomon::NCoordination
