#include <solomon/libs/cpp/coordination/load_balancer/cluster_state.h>

#include <library/cpp/testing/gtest/gtest.h>

using namespace NSolomon::NCoordination;

class TClusterStateTest: public testing::Test {
    void SetUp() override {
        State_ = {};
    }

protected:
    // NOLINTNEXTLINE(performance-unnecessary-value-param): false positive
    void AddNode(TNodeState node) {
        State_.AddNode(
            std::move(node),
            {},
            TInstant::Seconds(3)
        );
    }

    void AddNode(TString hostname, ui32 nodeId) {
        AddNode({nodeId, std::move(hostname)});
    }

    TClusterState& State() {
        return State_;
    }

private:
    TClusterState State_;
};

TEST_F(TClusterStateTest, LeaderByDefaultIsInvalid) {
    ASSERT_FALSE(State().Leader().IsValid());
}

TEST_F(TClusterStateTest, LeaderCanBeUpdated) {
    AddNode("foo", 1);
    State().SetLeader("foo", 1);

    ASSERT_TRUE(State().Leader().IsValid());
    ASSERT_EQ(State().Leader().OrderId, 1u);
    ASSERT_EQ(State().Leader().Hostname, "foo");
}

TEST_F(TClusterStateTest, NodeCanBeAdded) {
    TNodeState node{1, "foo"};
    AddNode(node);
    ASSERT_THAT(State().Nodes(), testing::ElementsAre(node));

    auto* actual = State().FindByHostname("foo");
    ASSERT_TRUE(actual);
    EXPECT_EQ(actual->NodeId(), 1u);
    EXPECT_EQ(actual->Hostname(), "foo");
}

TEST_F(TClusterStateTest, NodeCanBeUpdated) {
    AddNode("foo", 1);
    State().UpdateNode(1, ENodeState::Ok, TInstant::Seconds(5));

    auto aliveNodes = State().AliveNodes();
    ASSERT_EQ(aliveNodes.size(), 1u);
    ASSERT_TRUE(aliveNodes[0].IsOk());
}

TEST_F(TClusterStateTest, AliveNodesAreFilteredCorrectly) {
    ASSERT_TRUE(State().AliveNodes().empty());
    AddNode("foo", 1);

    ASSERT_TRUE(State().AliveNodes().empty());
    State().UpdateNode(1, ENodeState::Ok, TInstant::Seconds(5));
    ASSERT_EQ(State().AliveNodes().size(), 1u);

    State().MarkUnavailable(1, TInstant::Now());
    ASSERT_TRUE(State().AliveNodes().empty());
}
