#include <solomon/libs/cpp/coordination/load_balancer/load_balancer.h>

#include <library/cpp/testing/gtest/gtest.h>

#include <util/random/shuffle.h>

using namespace NSolomon::NCoordination;

MATCHER(CoversKeySpace, "") {
    if (arg.empty()) {
        return false;
    }

    const auto start = arg[0].first;
    auto end = arg[0].second;

    for (auto i = 1u; i < arg.size(); ++i) {
        auto&& slice = arg[i];

        if (slice.first != (end + 1)) {
            return false;
        }

        end = slice.second;
    }

    return start == Min<ui64>() && end == Max<ui64>();
}

TSlices GetSlices(const TVector<TAssignments>& assignments) {
    TSlices slices;
    for (auto&& assignment: assignments) {
        auto&& s = assignment.Slices();
        Copy(s.begin(), s.end(), std::back_inserter(slices));
    }

    std::sort(slices.begin(), slices.end());
    return slices;
}

TEST(TStaticBalancingTest, SlicesCoverKeySpace) {
    TVector<TNodeState> nodes{TNodeState{1}, TNodeState{2}, TNodeState{3}};

    {
        auto assignments = CreateStaticBalancer(128)->MakeAssignments(nodes);
        auto slices = GetSlices(assignments);
        ASSERT_THAT(slices, CoversKeySpace());
    }
    {
        auto assignments = CreateStaticBalancer(8)->MakeAssignments(nodes);
        auto slices = GetSlices(assignments);
        ASSERT_THAT(slices, CoversKeySpace());
    }
    {
        auto assignments = CreateStaticBalancer(4096)->MakeAssignments(nodes);
        auto slices = GetSlices(assignments);
        ASSERT_THAT(slices, CoversKeySpace());
    }
    {
        auto assignments = CreateStaticBalancer(1)->MakeAssignments(nodes);
        auto slices = GetSlices(assignments);
        ASSERT_THAT(slices, CoversKeySpace());
    }
}

TEST(TStaticBalancingTest, IncorrectShardCount) {
    ASSERT_THROW(CreateStaticBalancer(0), yexception);
    ASSERT_THROW(CreateStaticBalancer(100), yexception);
    ASSERT_THROW(CreateStaticBalancer(1000), yexception);
}

TEST(TStaticBalancingTest, OrderIsPreserved) {
    auto balancer = CreateStaticBalancer(128);

    TVector<TNodeState> nodes{TNodeState{1}, TNodeState{2}, TNodeState{3}};
    auto first = balancer->MakeAssignments(nodes);

    Shuffle(nodes.begin(), nodes.end());
    auto second = balancer->MakeAssignments(nodes);
    ASSERT_EQ(first, second);
}
