#include "view.h"

#include <solomon/libs/cpp/coordination/load_balancer/events.h>

#include <library/cpp/monlib/service/pages/html_mon_page.h>
#include <library/cpp/monlib/service/pages/templates.h>

namespace NSolomon::NCoordination {
namespace {
    static constexpr TStringBuf HEAD =
R"(<link rel='stylesheet' href='https://yastatic.net/bootstrap/3.3.1/css/bootstrap.min.css'/>
<script language='javascript' type='text/javascript' src='https://yastatic.net/jquery/2.1.3/jquery.min.js'></script>
<script language='javascript' type='text/javascript' src='https://yastatic.net/bootstrap/3.3.1/js/bootstrap.min.js'></script>
)"
    ;

    void RenderHtmlRow(IOutputStream& os, const TNodeState& node, const TLeaderInfo& leader) {
        HTML(os) {
        TABLER() {
            TABLED() {
                if (leader.NodeId == node.NodeId()) {
                    SPAN_CLASS("label label-primary") { os << "Leader"; }
                } else {
                    SPAN_CLASS("label label-default") { os << "Follower"; }
                }
            }

            TABLED() { os << node.Hostname(); }
            TABLED() { os << node.NodeId(); }
            TABLED() {
                if (node.IsOk()) {
                    SPAN_CLASS("label label-success") { os << node.State(); }
                } else {
                    SPAN_CLASS("label label-warning") { os << node.State(); }
                }
            }
        }
        }
    }
} // namespace
    void RenderHtml(IOutputStream& os, const TAssignments& assignments) {
        HTML(os) {
            DIV_CLASS("panel panel-info") {
                DIV_CLASS("panel-heading") { os << "Assigned slices"; }
                DIV_CLASS("panel-body") {
                    TABLE_CLASS("table table-condensed") {
                        TABLEHEAD() {
                            TABLER() {
                                TABLEH() { os << "From"; }
                                TABLEH() { os << "To"; }
                            }
                        }
                        TABLEBODY() {
                            for (auto&& slice: assignments.Slices()) {
                                TABLER() {
                                    TABLED() { os << slice.first; }
                                    TABLED() { os << slice.second; }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    void RenderHtml(IOutputStream& os, const TClusterState& clusterState) {
        HTML(os) {
            DIV_CLASS("panel panel-info") {
                DIV_CLASS("panel-heading") {
                    os << "Cluster state";
                }

                DIV_CLASS("panel-body") {
                    TABLE_CLASS("table table-condensed") {
                        TABLEHEAD() {
                            TABLER() {
                                TABLEH() {os << "Leader";}
                                TABLEH() {os << "Hostname";}
                                TABLEH() {os << "Node ID";}
                                TABLEH() {os << "State";}
                            }
                        }

                        TABLEBODY() {
                            for (auto&& node: clusterState.Nodes()) {
                                RenderHtmlRow(os, node, clusterState.Leader());
                            }
                        }
                    }
                }
            }
        }
    }

    void RenderHtmlPage(IOutputStream& os, const TAssignments& assignments, const TClusterState& clusterState) {
        HTML(os) {
            os << "<!DOCTYPE html>\n";
            os << "<title>Load balancer state</title>\n";
            HTML_TAG() {
                HEAD() {
                    os << HEAD;
                }

                BODY() {
                    RenderHtml(os, clusterState);
                    RenderHtml(os, assignments);
                }
            }
        }
    }
} // namespace NSolomon::NCoordination
