#pragma once

#include <library/cpp/threading/future/future.h>

#include <util/generic/ptr.h>
#include <util/datetime/base.h>

namespace NYdb {
    class TDriver;
} // namespace NYdb

namespace NSolomon {
    struct TLockDescription {
        TString Data;
        ui64 OrderId{0};
    };

    class ILockStateListener: public TThrRefBase {
    public:
        virtual ~ILockStateListener() = default;
        virtual void OnLock() = 0;
        virtual void OnUnlock() = 0;

        /**
         * @brief Notifies about an unrecoverable error
         */
        virtual void OnError(TString s) = 0;

        virtual void OnChanged(const TLockDescription& description) = 0;
    };

    using ILockStateListenerPtr = TIntrusivePtr<ILockStateListener>;

    class IDistributedLock {
    public:
        virtual ~IDistributedLock() = default;

        // future is completed once the lock has actually connected to a backend
        virtual NThreading::TFuture<void> Acquire(ILockStateListenerPtr listener) = 0;
        virtual NThreading::TFuture<void> Release() = 0;
    };

    using IDistributedLockPtr = std::shared_ptr<IDistributedLock>;

    struct TYdbLockConfig {
        const NYdb::TDriver& Driver;
        TString Path;
        TString Name;
        TString Data;
    };

    IDistributedLockPtr CreateYdbLock(const TYdbLockConfig& config);
    NThreading::TFuture<void> PrepareYdbLock(const TYdbLockConfig& config);
} // namespace NSolomon
