#pragma once

#include <solomon/libs/cpp/error_or/error_or.h>

#include <ydb/public/sdk/cpp/client/ydb_coordination/coordination.h>

#include <library/cpp/threading/future/future.h>

namespace NYdb {
    class TDriver;
} // namespace NYdb

namespace NSolomon {
    // Checks whether a directory exists and creates it in case it does not
    NThreading::TFuture<void> EnsureDirectoryExists(const NYdb::TDriver& driver, const TString& path);
    NThreading::TFuture<void> CreateSemaphore(const NYdb::TDriver& driver, const TString& nodePath, const TString& semaphoreName);

    using TSessionResult = TErrorOr<NYdb::NCoordination::TSession, NYql::TIssues>;
    using TAsyncSessionResult = NThreading::TFuture<TSessionResult>;

    class ISessionProvider: public TThrRefBase {
    public:
        virtual TAsyncSessionResult GetSession() = 0;
        virtual void Stop() = 0;
    };

    TIntrusivePtr<ISessionProvider> CreateSessionProvider(
        const NYdb::NCoordination::TClient& client,
        TString path,
        std::function<void()> sessionCloseHandler);
} // namespace NSolomon
