#pragma once

#include <library/cpp/ipv6_address/ipv6_address.h>
#include <library/cpp/threading/future/future.h>

namespace NSolomon {
    struct TDnsRequestTimeoutError: yexception {
    };

    struct TDnsClientInternalError: yexception {
    };

    struct TDnsBadRequestError: yexception {
    };

    struct TDnsRecordNotFound: yexception {
    };

    struct TSrvRecord {
        TString Host;
        ui16 Port{0};

        ui16 Weight{0};
        ui16 Priority{0};
    };

    // not a general purpose client -- just compensates some functionality absent in the library
    class IDnsClient {
    public:
        virtual ~IDnsClient() = default;
        virtual NThreading::TFuture<TVector<TSrvRecord>> GetSrvRecords(const TString& address) = 0;
        virtual NThreading::TFuture<TIpv6AddressesSet> GetAddresses(const TString& address, bool ipv6Only) = 0;
    };

    using IDnsClientPtr = TAtomicSharedPtr<IDnsClient>;

    IDnsClientPtr CreateDnsClient();
} // namespace NSolomon
