#include "poller.h"

#include <util/network/poller.h>
#include <util/network/pollerimpl.h>
#include <util/network/sock.h>

namespace NSolomon {
    class TAresPoller::TImpl: public TPollerImpl<TWithoutLocking> {
        using TBase = TPollerImpl<TWithoutLocking>;

    public:
        inline size_t DoWaitReal(void** ev, TEvent* events, size_t len, TDuration timeout) {
            const size_t ret = WaitD(events, len, timeout.ToDeadLine());

            for (size_t i = 0; i < ret; ++i) {
                ev[i] = ExtractEvent(&events[i]);
            }

            return ret;
        }

        inline size_t DoWait(void** ev, size_t len, TDuration timeout) {
            if (len == 1) {
                TEvent tmp;
                return DoWaitReal(ev, &tmp, 1, timeout);
            } else {
                TTempArray<TEvent> tmpEvents(len);
                return DoWaitReal(ev, tmpEvents.Data(), len, timeout);
            }
        }
    };

    TAresPoller::TAresPoller()
        : Impl_{new TAresPoller::TImpl}
    {
    }

    TAresPoller::~TAresPoller() = default;

    void TAresPoller::AddWait(ares_socket_t sock, void* cookie) {
        Impl_->Set(cookie, sock, CONT_POLL_READ|CONT_POLL_WRITE);
    }

    void TAresPoller::Unwait(ares_socket_t sock) {
        Impl_->Remove(sock);
    }

    size_t TAresPoller::WaitT(void** events, size_t len, TDuration timeout) {
        return Impl_->DoWait(events, len, timeout);
    }
} // namespace NSolomon
