#pragma once

#include <util/datetime/base.h>
#include <util/generic/ptr.h>
#include <util/network/pollerimpl.h>

#include <contrib/libs/c-ares/include/ares.h>

namespace NSolomon {
    struct TEvent {
        TEvent(ares_socket_t socket = ARES_SOCKET_BAD)
            : Socket{socket}
        {
        }

        ares_socket_t Socket;
    };

    // NOT thread-safe
    class TAresPoller {
    public:
        TAresPoller();
        ~TAresPoller();

        void AddWait(ares_socket_t sock, void* cookie);
        void Unwait(ares_socket_t sock);

        size_t WaitT(void** events, size_t len, TDuration timeout);

    private:
        class TImpl;
        THolder<TImpl> Impl_;
    };
} // namespace NSolomon
