#include "event.h"

#include <errno.h>

namespace NSolomon {
    TPollableEvent::TPollableEvent() {
        TPipeHandle::Pipe(Reader_, Writer_);
        SetNonBlock(Reader_);
    }

    void TPollableEvent::Signal() {
        while (Writer_.Write("x", 1) == -1) {
            if (errno == EINTR) continue;
            else ythrow TSystemError() << "cannot signal pollable event";
        }
    }

    void TPollableEvent::Reset() {
        ui8 buf[16];
        ssize_t n = 0;
        do {
            n = Reader_.Read(buf, sizeof(buf));
            if (n == -1) {
                if (errno == EINTR) continue;
                else if (errno == EAGAIN) break;
                else ythrow TSystemError() << "cannot reset pollable event";
            }
        } while (n != 0);
    }

    int TPollableEvent::Fd() const {
        return Reader_;
    }
} // namespace NSolomon
