#pragma once

#include <util/system/pipe.h>
#include <util/network/socket.h>
#include <atomic>

namespace NSolomon {
    struct TPollableEvent {
        TPollableEvent();

        void Signal();
        void Reset();
        int Fd() const;

    private:
        std::atomic<int> Cnt_{0};
        TPipeHandle Reader_;
        TPipeHandle Writer_;
    };
} // namespace NSolomon
