#include <solomon/libs/cpp/ewma/ewma2.h>

#include <library/cpp/testing/gtest/gtest.h>

using namespace NSolomon;

template <typename T>
class TEwmaTest: public ::testing::Test {
};

using Types = ::testing::Types<TEwma, TAtomicEwma>;
TYPED_TEST_SUITE(TEwmaTest, Types);

TYPED_TEST(TEwmaTest, DefaultInitialValue) {
    auto now = TInstant::Now();
    TypeParam ewma{TDuration::Seconds(5), now};
    EXPECT_DOUBLE_EQ(ewma.Value(), 0.0);
}

TYPED_TEST(TEwmaTest, InitialValue) {
    auto now = TInstant::Now();
    TypeParam ewma{TDuration::Seconds(5), now, 42.0};
    EXPECT_DOUBLE_EQ(ewma.Value(), 42.0);
}

TYPED_TEST(TEwmaTest, ConstantValue) {
    auto now = TInstant::Now();
    TypeParam ewma{TDuration::Seconds(5), now, 0.0};

    double value = 100.0;
    for (int i = 0; i < 100; i++) {
        ewma.Add(now, value);
        now += TDuration::Seconds(1);
    }

    ASSERT_NEAR(ewma.Value(), value, 0.001);
}

TYPED_TEST(TEwmaTest, UpdateConstantValue) {
    auto now = TInstant::Now();
    TypeParam ewma{TDuration::Seconds(5), now, 0.0};

    double value = 100.0;
    for (int i = 0; i < 100; i++) {
        ewma.Add(now, value);
        now += TDuration::Seconds(1);
    }

    double value2 = 1000.0;
    for (int i = 0; i < 100; i++) {
        ewma.Add(now, value2);
        now += TDuration::Seconds(1);
    }

    ASSERT_NEAR(ewma.Value(), value2, 0.001);
}

TYPED_TEST(TEwmaTest, HalfLife) {
    auto now = TInstant::Now();
    auto halfLife = TDuration::Seconds(5);

    double initial = 100.0;
    TypeParam ewma{halfLife, now, initial};

    double previous = ewma.Value();
    double next = 1000.0;
    ewma.Add(now + halfLife, next);

    double expected = previous + (next - previous) / 2; // half of the difference
    ASSERT_NEAR(ewma.Value(), expected, 0.001);
}
