#include <solomon/libs/cpp/ewma/ewma2.h>
#include <solomon/libs/cpp/ewma/ewma_rate.h>

#include <library/cpp/testing/gtest/gtest.h>

#include <util/random/random.h>

using namespace NSolomon;

TEST(TEwmaRate, ConstRate) {
    auto now = TInstant::Now();
    TEwmaRate<TEwma> rate{TDuration::Seconds(1), now};

    for (int i = 0; i < 100; ++i) {
        rate.Tick(now);
        now += TDuration::Seconds(1);
    }

    EXPECT_NEAR(rate.Rate(now), 1, 0.001);
}

TEST(TEwmaRate, IncreasingRate) {
    auto now = TInstant::Now();
    TEwmaRate<TEwma> rate{TDuration::Seconds(1), now};

    for (int i = 0; i < 10; ++i) {
        rate.Tick(now);
        now += TDuration::Seconds(2);
    }

    for (int i = 0; i < 200; ++i) {
        rate.Tick(now);
        now += TDuration::MilliSeconds(100);
    }

    EXPECT_NEAR(rate.Rate(now), 10, 0.001);
}

TEST(TEwmaRate, NonConstRate) {
    SetRandomSeed(47);

    auto now = TInstant::Now();
    TEwmaRate<TEwma> rate{TDuration::Seconds(1), now};

    for (int i = 0; i < 1000; ++i) {
        rate.Tick(now);
        ui64 deltaMillis = 450 + RandomNumber<ui64>(100); // [450, 550) avg at 500ms
        now += TDuration::MilliSeconds(deltaMillis);
    }

    EXPECT_NEAR(rate.Rate(now), 2, 0.1);
}

TEST(TEwmaRate, ZeroInitValue) {
    auto now = TInstant::Now();
    TEwmaRate<TEwma> rate{TDuration::Seconds(1), now, 0.0};
    EXPECT_EQ(rate.Rate(now), 0.0);

    for (int i = 0; i < 20; ++i) {
        rate.Tick(now);
        now += TDuration::Seconds(1);
    }

    EXPECT_NEAR(rate.Rate(now), 1, 0.001);
}
