#include <solomon/libs/cpp/ewma/ewma.h>

#include <library/cpp/monlib/metrics/metric_registry.h>
#include <library/cpp/testing/gtest/gtest.h>

TEST(TEWMAMeanTest, TickWithoutUpdate) {
    NMonitoring::TMetricRegistry registry;
    auto* gauge = registry.Gauge({ {"label", "value"} });

    auto ewma = MakeHolder<NSolomon::TEWMAMean>(gauge, NSolomon::EWMA_ALPHA_1MIN);
    ewma->Tick();

    auto value = gauge->Get();
    ASSERT_EQ(value, 0);
}

TEST(TEWMAMeanTest, HappyPath) {
    NMonitoring::TMetricRegistry registry;
    auto* gauge = registry.Gauge({ {"label", "value"} });

    auto ewma = MakeHolder<NSolomon::TEWMAMean>(gauge, NSolomon::EWMA_ALPHA_1MIN);
    ewma->Update(1);
    ewma->Update(2);
    ewma->Update(3);

    {
        auto value = gauge->Get();
        ASSERT_EQ(value, 0);
    }

    ewma->Tick();

    double expectedValue = double(1 + 2 + 3) / 3;
    {
        auto value = gauge->Get();
        ASSERT_EQ(value, expectedValue);
    }

    ewma->Tick();

    {
        auto value = gauge->Get();
        ASSERT_DOUBLE_EQ(value, NSolomon::EWMA_ALPHA_1MIN * (-expectedValue) + expectedValue);
    }
}

TEST(TEWMASumTest, TickWithoutUpdate) {
    NMonitoring::TMetricRegistry registry;
    auto* gauge = registry.Gauge({ {"label", "value"} });

    auto ewma = MakeHolder<NSolomon::TEWMASum>(gauge, NSolomon::EWMA_ALPHA_1MIN);
    ewma->Tick();

    auto value = gauge->Get();
    ASSERT_EQ(value, 0);
}

TEST(TEWMASumTest, HappyPath) {
    NMonitoring::TMetricRegistry registry;
    auto* gauge = registry.Gauge({ {"label", "value"} });

    auto ewma = MakeHolder<NSolomon::TEWMASum>(gauge, NSolomon::EWMA_ALPHA_1MIN);
    ewma->Update(1);
    ewma->Update(2);
    ewma->Update(3);

    {
        auto value = gauge->Get();
        ASSERT_EQ(value, 0);
    }

    ewma->Tick();

    double expectedValue = 1 + 2 + 3;
    {
        auto value = gauge->Get();
        ASSERT_EQ(value, expectedValue);
    }

    ewma->Tick();

    {
        auto value = gauge->Get();
        ASSERT_DOUBLE_EQ(value, NSolomon::EWMA_ALPHA_1MIN * (-expectedValue) + expectedValue);
    }
}
