#pragma once

#include <util/generic/string.h>

#include <optional>

namespace NSolomon {

/**
 * Checks that given string contains correct glob pattern.
 * See https://man7.org/linux/man-pages/man7/glob.7.html.
 *
 * NOTE: only '?' and '*' currently supported.
 *
 * @param str  string to check
 *
 * @return {@code true} iff string contains correct glob pattern,
 *         {@code false} otherwise.
 */
bool IsGlob(TStringBuf str);

/**
 * Checks that given string matched by glob pattern.
 *
 * NOTE: only '?' and '*' currently supported in glob pattern.
 *
 * @param glob   glob pattern
 * @param str    string to match
 *
 * @return {@code true} iff string matches with glob pattern
 *         {@code false} otherwise.
 */
bool IsGlobMatch(TStringBuf glob, TStringBuf str);

/**
 * Try to convert simple regular expressions into glob pattern.
 *
 * @param regex  string with regular expression
 *
 * @return an optional object that contains a glob pattern iff conversion is possible,
 *         an empty optional object otherwise.
 */
std::optional<TString> GlobFromRegex(TStringBuf regex);

} // namespace NSolomon
