#pragma once

#include <solomon/libs/cpp/error_or/error_or.h>
#include <library/cpp/grpc/client/grpc_client_low.h>

namespace NSolomon {

class TApiCallError: public TGenericError {
public:
    using TGenericError::TGenericError;
    TApiCallError(::NGrpc::TGrpcStatus status, TString message)
        : TGenericError{std::move(message)}
        , GrpcStatus_{std::move(status)}
    {
    }

    TApiCallError(TGenericError err)
        : TGenericError{std::move(err)}
    {
    }

    bool IsTransportError() const noexcept {
        return !GrpcStatus_.Ok();
    }

    int Status() const noexcept {
        return GrpcStatus_.GRpcStatusCode;
    }

private:
    ::NGrpc::TGrpcStatus GrpcStatus_;
};

} // namespace NSolomon
