#include "counters.h"

#include <solomon/libs/cpp/grpc/status/code.h>

namespace NSolomon {
    void TBaseCallCounters::ReportCallStart() {
        Started_->Inc();
        Inflight_->Inc();
    }

    void TBaseCallCounters::ReportDelivery(ui64 durationMillis) {
        Delivery_->Record(durationMillis);
    }

    void TBaseCallCounters::ReportDelivery(TDuration duration) {
        ReportDelivery(duration.MilliSeconds());
    }

    void TBaseCallCounters::ReportInboundBytes(ui64 bytes) {
        InboundBytes_->Add(bytes);
    }

    void TBaseCallCounters::ReportOutboundBytes(ui64 bytes) {
        OutboundBytes_->Add(bytes);
    }

    void TBaseCallCounters::ReportCallStats(grpc::StatusCode code, TDuration duration) {
        Timings_->Record(duration.MilliSeconds());
        Completed_->Inc();
        Inflight_->Dec();
        ResolveStatus(code)->Inc();
    }

    NMonitoring::ILabelsPtr TBaseCallCounters::MakeLabels(TStringBuf name, const NMonitoring::TLabels& additional) {
        NMonitoring::ILabelsPtr result{new NMonitoring::TLabels};
        TString fullName = Prefix_ + name;
        result->Add("sensor", fullName);
        for (const auto& l: CommonLabels_) {
            result->Add(l);
        }
        for (const auto& l: additional) {
            result->Add(l);
        }
        return result;
    }

    NMonitoring::IRate* TBaseCallCounters::ResolveStatus(grpc::StatusCode code) {
        {
            auto status = Status_.Read();
            if (auto it = status->find(code); it != status->end()) {
                return it->second;
            }
        }

        auto codeStr = NGrpc::StatusCodeToString(code);
        auto* metric = Registry_.Rate(MakeLabels(".call.status", {{"code", codeStr}}));
        {
            auto status = Status_.Write();
            (*status)[code] = metric;
        }
        return metric;
    }
} // namespace NSolomon
