#pragma once

#include <solomon/libs/cpp/actors/events/events.h>
#include <solomon/libs/cpp/actors/events/slots.h>

#include <library/cpp/actors/core/event_local.h>
#include <library/cpp/grpc/server/grpc_request_base.h>

namespace NSolomon::NGrpc {

class TServerEvents: private TEventSlot<EEventSpace::Libs, ELibSlot::GrpcServer> {
    enum {
        Request = SpaceBegin,
        Response,
        Error,
        Timeout,
        End,
    };
    static_assert(End < SpaceEnd, "too many event types");

public:
    struct TRequest: public NActors::TEventLocal<TRequest, Request> {
        ::NGrpc::IRequestContextBase* ReqCtx;
        TInstant ReceivedAt;

        TRequest(::NGrpc::IRequestContextBase* reqCtx, TInstant receivedAt)
            : ReqCtx{reqCtx}
            , ReceivedAt{receivedAt}
        {
        }
    };

    struct TResponse: public NActors::TEventLocal<TResponse, Response> {
        std::unique_ptr<NProtoBuf::Message> Message;
        grpc::StatusCode Code;

        explicit TResponse(std::unique_ptr<NProtoBuf::Message> message, grpc::StatusCode code = grpc::OK) noexcept
            : Message{std::move(message)}
            , Code{code}
        {
        }
    };

    struct TError: public NActors::TEventLocal<TError, Error> {
        grpc::StatusCode Code;
        TString Message;

        TError(grpc::StatusCode code, TString message) noexcept
            : Code{code}
            , Message{std::move(message)}
        {
        }
    };

    struct TTimeout: public NActors::TEventLocal<TTimeout, Timeout> {
    };
};

} // namespace NSolomon::NGrpc
