#include "server.h"

#include <solomon/libs/cpp/actors/config/log_component.pb.h>
#include <solomon/libs/cpp/config/units.h>
#include <solomon/libs/cpp/grpc/interceptor/server_call_interceptor.h>

#include <library/cpp/grpc/server/actors/logger.h>

#include <util/generic/size_literals.h>

namespace NSolomon::NGrpc {

THolder<::NGrpc::TGRpcServer> MakeGRpcServerFromConfig(
    NActors::TActorSystem& actorSystem,
    NMonitoring::IMetricRegistry& registry,
    const yandex::solomon::config::rpc::TGrpcServerConfig& config)
{
    Y_ENSURE(config.PortSize() == 1, "expected exactly one rpc port, got " << config.PortSize());
    auto port = config.GetPort(0);
    Y_ENSURE(port != 0, "rpc port not set");

    auto maxMessageSize = config.HasMaxMessageSize() ? FromProtoDataSize(config.GetMaxMessageSize()) : 4_MB;
    Y_ENSURE(maxMessageSize != 0, "max message size not set");

    auto threads = config.GetWorkerThreads();
    if (threads == 0) {
        threads = 4;
    }

    return MakeHolder<::NGrpc::TGRpcServer>(::NGrpc::TServerOptions()
            .SetHost("[::]") // TODO: make configurable
            .SetPort(port)
            .SetWorkerThreads(threads)
            .SetMaxMessageSize(maxMessageSize)
            .SetServerBuilderMutator([&registry](grpc::ServerBuilder& builder){
                std::vector<TServerInterceptorFactoryPtr> interceptors;
                interceptors.push_back(NSolomon::CreateServerCounterInterceptorFactory(registry));
                builder.experimental().SetInterceptorCreators(std::move(interceptors));
            })
            .SetLogger(::NGrpc::CreateActorSystemLogger(actorSystem, ELogComponent::GrpcApi)));
}

} // namespace NSolomon::NGrpc
