#pragma once

#include <solomon/libs/cpp/grpc/client/client.h>
#include <solomon/libs/cpp/grpc/server/ut/protos/math_service.grpc.pb.h>

namespace NSolomon {

class TMathClient {
public:
    TMathClient(TStringBuf host, ui16 port) {
        yandex::solomon::config::rpc::TGrpcClientConfig conf;
        conf.AddAddresses(TStringBuilder{} << host << ':' << port);
        conf.SetWorkerThreads(2);

        Connection_ = CreateGrpcServiceConnection<yandex::monitoring::test::MathService>(
                conf,
                false,
                *NMonitoring::TMetricRegistry::Instance(),
                CreateGrpcThreadPool(conf),
                "ut-client");
    }

    NThreading::TFuture<double> Add(double left, double right) {
        using yandex::monitoring::test::MathService;
        using yandex::monitoring::test::Args;
        using yandex::monitoring::test::Result;
        return Request<Args, Result,  &MathService::Stub::AsyncAdd>(ToArgs(left, right));
    }

    NThreading::TFuture<double> Sub(double left, double right) {
        using yandex::monitoring::test::MathService;
        using yandex::monitoring::test::Args;
        using yandex::monitoring::test::Result;
        return Request<Args, Result,  &MathService::Stub::AsyncSub>(ToArgs(left, right));
    }

    NThreading::TFuture<double> Mul(double left, double right) {
        using yandex::monitoring::test::MathService;
        using yandex::monitoring::test::Args;
        using yandex::monitoring::test::Result;
        return Request<Args, Result,  &MathService::Stub::AsyncMul>(ToArgs(left, right));
    }

    NThreading::TFuture<double> Div(double left, double right) {
        using yandex::monitoring::test::MathService;
        using yandex::monitoring::test::Args;
        using yandex::monitoring::test::Result;
        return Request<Args, Result,  &MathService::Stub::AsyncDiv>(ToArgs(left, right));
    }

private:
    yandex::monitoring::test::Args ToArgs(double left, double right) {
        yandex::monitoring::test::Args args;
        args.set_left(left);
        args.set_right(right);
        return args;
    }

    template <typename TReq, typename TRes, auto Request>
    NThreading::TFuture<double> Request(const TReq& request) {
        auto promise = NThreading::NewPromise<double>();
        auto cb = [promise] (::NGrpc::TGrpcStatus&& status, TRes&& result) mutable {
            if (status.Ok()) {
                promise.SetValue(result.value());
            } else {
                promise.SetException(status.Msg);
            }
        };

        Connection_->Request<TReq, TRes>(request, std::move(cb), Request);
        return promise.GetFuture();
    }

private:
    std::unique_ptr<TGrpcServiceConnection<yandex::monitoring::test::MathService>> Connection_;
};

} // namespace NSolomon
