#pragma once

#include <solomon/libs/cpp/grpc/server/ut/protos/math_service.grpc.pb.h>

#include <library/cpp/grpc/server/grpc_request.h>
#include <library/cpp/grpc/server/grpc_server.h>

namespace NSolomon {

class TMathService: public ::NGrpc::TGrpcServiceBase<yandex::monitoring::test::MathService> {
public:
    void InitService(grpc::ServerCompletionQueue* cq, ::NGrpc::TLoggerPtr logger) override {
        using yandex::monitoring::test::MathService;
        using yandex::monitoring::test::Args;
        using yandex::monitoring::test::Result;

        RegisterHandler<Args, Result, &MathService::AsyncService::RequestAdd, AddMethodImpl>(cq, logger, "Add");
        RegisterHandler<Args, Result, &MathService::AsyncService::RequestSub, SubMethodImpl>(cq, logger, "Sub");
        RegisterHandler<Args, Result, &MathService::AsyncService::RequestMul, MulMethodImpl>(cq, logger, "Mul");
        RegisterHandler<Args, Result, &MathService::AsyncService::RequestDiv, DivMethodImpl>(cq, logger, "Div");
    }

    bool IncRequest() {
        return true;
    }

    void DecRequest() {
    }

private:
    template <typename TReq, typename TResp, auto Request, auto MethodImpl>
    void RegisterHandler(grpc::ServerCompletionQueue* cq, ::NGrpc::TLoggerPtr logger, const char* name) {
        using yandex::monitoring::test::Args;
        using yandex::monitoring::test::Result;

        MakeIntrusive<::NGrpc::TGRpcRequest<TReq, TResp, TMathService>>(
                this,
                &Service_,
                cq,
                [](::NGrpc::IRequestContextBase* ctx) {
                    auto* args = reinterpret_cast<const Args*>(ctx->GetRequest());
                    Result result;
                    result.set_value(MethodImpl(*args));
                    ctx->Reply(&result);
                },
                Request,
                name,
                logger,
                ::NGrpc::FakeCounterBlock())->Run();
    }

    static double AddMethodImpl(const yandex::monitoring::test::Args& args) {
        return args.left() + args.right();
    }

    static double SubMethodImpl(const yandex::monitoring::test::Args& args) {
        return args.left() - args.right();
    }

    static double MulMethodImpl(const yandex::monitoring::test::Args& args) {
        return args.left() * args.right();
    }

    static double DivMethodImpl(const yandex::monitoring::test::Args& args) {
        return args.left() / args.right();
    }
};

} // namespace NSolomon
