#include "math_client.h"
#include "math_service.h"
#include "math_service_actor.h"

#include <solomon/libs/cpp/actors/test_runtime/actor_runtime.h>

#include <library/cpp/testing/common/network.h>
#include <library/cpp/testing/gtest/gtest.h>

using namespace NSolomon;

TEST(TGrpcServiceTest, SimpleService) {
    auto port = NTesting::GetFreePort();

    auto server = MakeHolder<::NGrpc::TGRpcServer>(::NGrpc::TServerOptions().SetHost("localhost").SetPort(port));
    server->AddService(MakeIntrusive<TMathService>());
    server->Start();

    TMathClient client{"localhost", port};

    try {
        double sum = client.Add(1.1, 2.2).GetValueSync();
        ASSERT_DOUBLE_EQ(sum, 1.1 + 2.2);

        double sub = client.Sub(3.3, 4.4).GetValueSync();
        ASSERT_DOUBLE_EQ(sub, 3.3 - 4.4);

        double mul = client.Mul(5.5, 6.6).GetValueSync();
        ASSERT_DOUBLE_EQ(mul, 5.5 * 6.6);

        double div = client.Div(7.7, 8.8).GetValueSync();
        ASSERT_DOUBLE_EQ(div, 7.7 / 8.8);
    } catch (...) {
        FAIL() << CurrentExceptionMessage();
    }

    server->Stop();
}

TEST(TGrpcServiceTest, ActorService) {
    auto port = NTesting::GetFreePort();

    auto runtime = TTestActorRuntime::CreateInited(1, true, true);

    auto server = MakeHolder<::NGrpc::TGRpcServer>(::NGrpc::TServerOptions().SetHost("localhost").SetPort(port));
    server->AddService(MakeIntrusive<TMathServiceActor>(*runtime->SingleSys()));
    server->Start();

    TMathClient client{"localhost", port};

    try {
        double sum = client.Add(1.1, 2.2).GetValueSync();
        ASSERT_DOUBLE_EQ(sum, 1.1 + 2.2);

        double sub = client.Sub(3.3, 4.4).GetValueSync();
        ASSERT_DOUBLE_EQ(sub, 3.3 - 4.4);

        double mul = client.Mul(5.5, 6.6).GetValueSync();
        ASSERT_DOUBLE_EQ(mul, 5.5 * 6.6);

        double div = client.Div(7.7, 8.8).GetValueSync();
        ASSERT_DOUBLE_EQ(div, 7.7 / 8.8);
    } catch (...) {
        FAIL() << CurrentExceptionMessage();
    }

    server->Stop();
    runtime.Reset();
}
