#include "stats_filter.h"
#include "req_ctx_wrapper.h"

#include <solomon/libs/cpp/sync/rw_lock.h>

#include <library/cpp/threading/atomic_shared_ptr/atomic_shared_ptr.h>

#include <util/random/random.h>

namespace NSolomon::NGrpc {

namespace {

class TStatsFilter : public IStatsFilter {
public:
    TStatsFilter(const TStatsFilterConf& fConf, const TStatsTableConf& tConf)
        : Config_{new TStatsFilterConf{fConf}}
        , Table_{new TStatsTable{tConf}}
    {
    }

    TStatsFilter() {}

    ::NGrpc::IRequestContextBase* FilterRequest(::NGrpc::IRequestContextBase* reqCtx, TInstant timestamp) const noexcept override {
        if ((RandomNumber<ui32>() % 100) < Config_->SamplingRate &&
                IsMatched(reqCtx->GetRequest()->GetTypeName(), Config_->CaptureType)) {
            return new TMeasuredGrpcRequestCtx(reqCtx, Table_, Config_->MinimumInterestingTime, timestamp);
        } else {
            return reqCtx;
        }
    }

    void SetFilterConfig(const TStatsFilterConf& conf) override {
        Config_ = TTrueAtomicSharedPtr<TStatsFilterConf>{new TStatsFilterConf{conf}};
    }

    TStatsFilterConf GetFilterConfig() override {
        return *Config_;
    }

    std::shared_ptr<TStatsTable> GetStatsTable() override {
        return Table_;
    }

    ~TStatsFilter() = default;

private:
    bool IsMatched(TStringBuf str, TStringBuf substr) const {
        return !substr || str.Contains(substr) || IsGlobMatch(substr, str);
    }

private:
    TTrueAtomicSharedPtr<TStatsFilterConf> Config_;
    std::shared_ptr<TStatsTable> Table_;
};

} // namespace

std::shared_ptr<IStatsFilter> CreateStatsFilter(const TStatsFilterConf& fConf, const TStatsTableConf& tConf) {
    return std::make_shared<TStatsFilter>(fConf, tConf);
}

} // namespace NSolomon::NGrpc
