#pragma once

#include "stats_table.h"

#include <library/cpp/grpc/server/grpc_request_base.h>
#include <library/cpp/grpc/server/grpc_request.h>

#include <util/system/types.h>
#include <util/generic/fwd.h>
#include <util/datetime/base.h>

#include <memory>

namespace NSolomon::NGrpc {

struct TStatsFilterConf {
    ui32 SamplingRate{0};
    TString CaptureType{};
    TDuration MinimumInterestingTime{TDuration::Seconds(10)};
};

class IStatsFilter {
public:
    virtual ::NGrpc::IRequestContextBase* FilterRequest(::NGrpc::IRequestContextBase*, TInstant) const noexcept {
        return nullptr;
    }

    virtual void SetFilterConfig(const TStatsFilterConf&) {
    }

    virtual TStatsFilterConf GetFilterConfig() {
        return {};
    }

    virtual std::shared_ptr<TStatsTable> GetStatsTable() {
        return nullptr;
    }

    virtual ~IStatsFilter() = default;
};

std::shared_ptr<IStatsFilter> CreateStatsFilter(const TStatsFilterConf&, const TStatsTableConf&);

} // namespace NSolomon::NGrpc
