#pragma once

#include <library/cpp/monlib/metrics/metric_registry.h>

using namespace NMonitoring;

namespace NSolomon::NGrpc {

class TStatsTableMetrics {
public:
    explicit TStatsTableMetrics(TMetricRegistry& registry)
        : Rows_{registry.IntGauge({{"sensor", "grpc.server.stats_table.rows"}})}
    {
    }

    void WriteRows(size_t rows) noexcept {
        Rows_->Set(rows);
    }

private:
    TIntGauge* Rows_;
};

} // namespace NSolomon::NGrpc
