#pragma once

#include <util/stream/output.h>
#include <util/string/cast.h>

#include <contrib/libs/grpc/include/grpcpp/impl/codegen/status_code_enum.h>

namespace NGrpc {
constexpr TStringBuf StatusCodeToString(int statusCode) {
    switch (statusCode) {
        case grpc::StatusCode::OK: return TStringBuf("OK");
        case grpc::StatusCode::RESOURCE_EXHAUSTED: return TStringBuf("RESOURCE_EXHAUSTED");
        case grpc::StatusCode::INTERNAL: return TStringBuf("INTERNAL");
        case grpc::StatusCode::ABORTED: return TStringBuf("ABORTED");
        case grpc::StatusCode::ALREADY_EXISTS: return TStringBuf("ALREADY_EXISTS");
        case grpc::StatusCode::CANCELLED: return TStringBuf("CANCELLED");
        case grpc::StatusCode::DATA_LOSS: return TStringBuf("DATA_LOSS");
        case grpc::StatusCode::DEADLINE_EXCEEDED: return TStringBuf("DEADLINE_EXCEEDED");
        case grpc::StatusCode::DO_NOT_USE: return TStringBuf("DO_NOT_USE");
        case grpc::StatusCode::FAILED_PRECONDITION: return TStringBuf("FAILED_PRECONDITION");
        case grpc::StatusCode::INVALID_ARGUMENT: return TStringBuf("INVALID_ARGUMENT");
        case grpc::StatusCode::NOT_FOUND: return TStringBuf("NOT_FOUND");
        case grpc::StatusCode::OUT_OF_RANGE: return TStringBuf("OUT_OF_RANGE");
        case grpc::StatusCode::PERMISSION_DENIED: return TStringBuf("PERMISSION_DENIED");
        case grpc::StatusCode::UNAUTHENTICATED: return TStringBuf("UNAUTHENTICATED");
        case grpc::StatusCode::UNAVAILABLE: return TStringBuf("UNAVAILABLE");
        case grpc::StatusCode::UNIMPLEMENTED: return TStringBuf("UNIMPLEMENTED");
        default: return TStringBuf("UNKNOWN");
    }
}
} // NGrpc
