#include <solomon/libs/cpp/grpc/status/code.h>

#include <library/cpp/testing/gtest/gtest.h>

TEST(ToStringConverTest, ToString) {
    EXPECT_EQ("OK", NGrpc::StatusCodeToString(grpc::StatusCode::OK));
    EXPECT_EQ("UNKNOWN", NGrpc::StatusCodeToString(grpc::StatusCode::UNKNOWN));
    EXPECT_EQ("UNIMPLEMENTED", NGrpc::StatusCodeToString(grpc::StatusCode::UNIMPLEMENTED));
    EXPECT_EQ("UNAUTHENTICATED", NGrpc::StatusCodeToString(grpc::StatusCode::UNAUTHENTICATED));
    EXPECT_EQ("PERMISSION_DENIED", NGrpc::StatusCodeToString(grpc::StatusCode::PERMISSION_DENIED));
    EXPECT_EQ("UNAVAILABLE", NGrpc::StatusCodeToString(grpc::StatusCode::UNAVAILABLE));
    EXPECT_EQ("OUT_OF_RANGE", NGrpc::StatusCodeToString(grpc::StatusCode::OUT_OF_RANGE));
    EXPECT_EQ("NOT_FOUND", NGrpc::StatusCodeToString(grpc::StatusCode::NOT_FOUND));
    EXPECT_EQ("INVALID_ARGUMENT", NGrpc::StatusCodeToString(grpc::StatusCode::INVALID_ARGUMENT));
    EXPECT_EQ("FAILED_PRECONDITION", NGrpc::StatusCodeToString(grpc::StatusCode::FAILED_PRECONDITION));
    EXPECT_EQ("DO_NOT_USE", NGrpc::StatusCodeToString(grpc::StatusCode::DO_NOT_USE));
    EXPECT_EQ("DEADLINE_EXCEEDED", NGrpc::StatusCodeToString(grpc::StatusCode::DEADLINE_EXCEEDED));
    EXPECT_EQ("DATA_LOSS", NGrpc::StatusCodeToString(grpc::StatusCode::DATA_LOSS));
    EXPECT_EQ("CANCELLED", NGrpc::StatusCodeToString(grpc::StatusCode::CANCELLED));
    EXPECT_EQ("ALREADY_EXISTS", NGrpc::StatusCodeToString(grpc::StatusCode::ALREADY_EXISTS));
    EXPECT_EQ("ABORTED", NGrpc::StatusCodeToString(grpc::StatusCode::ABORTED));
    EXPECT_EQ("INTERNAL", NGrpc::StatusCodeToString(grpc::StatusCode::INTERNAL));
    EXPECT_EQ("RESOURCE_EXHAUSTED", NGrpc::StatusCodeToString(grpc::StatusCode::RESOURCE_EXHAUSTED));
}

TEST(ToStringConverTest, UnknownNumber) {
    EXPECT_EQ("UNKNOWN", NGrpc::StatusCodeToString(100500));
    EXPECT_EQ("UNKNOWN", NGrpc::StatusCodeToString(-123));
}
