#include "host_resolver.h"

#include <util/generic/yexception.h>
#include <util/generic/vector.h>

namespace NSolomon {
namespace {

class TMuxResolver: public IHostResolver {
public:
    explicit TMuxResolver(TVector<IHostResolverPtr> delegates) {
        Delegates_.reserve(delegates.size());
        for (auto&& d: delegates) {
            TStringBuf scheme = d->Scheme();
            bool emplaced = Delegates_.emplace(scheme, std::move(d)).second;
            Y_ENSURE(emplaced, "duplication of resolvers with scheme: " << scheme);
        }
    }

    TStringBuf Scheme() const override {
        return {};
    }

    void Resolve(TStringBuf name, TAddressSet* addresses) const override {
        TStringBuf scheme, hostPort;
        if (!name.TrySplit(TStringBuf("://"), scheme, hostPort)) {
            addresses->insert(TString{name});
        } else if (auto it = Delegates_.find(scheme); it != Delegates_.end()) {
            it->second->Resolve(name, addresses);
        } else {
            ythrow yexception() << "unsupported host resolver scheme: " << scheme;
        }
    }

private:
    THashMap<TStringBuf, IHostResolverPtr> Delegates_;
};

} // namespace

IHostResolverPtr MuxResolver(TVector<IHostResolverPtr> delegates) {
    return std::make_unique<TMuxResolver>(std::move(delegates));
}

} // namespace NSolomon
