#pragma once

#include <solomon/libs/cpp/http/client/http.h>

namespace NSolomon {

struct TCurlBindOptions {
    // This sets a host name or an IP address to bind socket. Be aware host names are resolved synchronously.
    TString Host;
    // This sets the local port number of the socket used for the connection. 0 - means "use any free port"
    ui16 Port{0};
    // The range argument is the number of attempts that will be used to find a working local port number.
    // It starts with the given {Port} and adds one to the number for each retry.
    ui16 PortRange{0};
};

struct TCurlClientOptions {
    /**
     * This name will be used in client metrics and for human-readable names of created threads, so keep it short.
     */
    TString Name{"curl"};

    /**
     * Number of threads to run event loop, where will be processed sending and receiving data.
     */
    size_t WorkerThreads{1};

    /**
     * Number of threads to invoke completion callback on. If 0, callbacks are executed on the worker thread.
     */
    size_t HandlerThreads{0};

    /**
     * DNS cache lifetime with second precision.
     *   - TDuration::Zero() -- cache is disabled (default behavioral)
     *   - TDuration::Max()  -- lifetime is infinite.
     */
    TDuration DnsCacheLifetime;

    TString CaCertDir{"/etc/ssl/certs"};
    ui64 MaxInflight{0};
    ui64 QueueSizeLimit{0};

    /**
     * Allows to set options to bind local socket before establishing a new connection.
     */
    std::optional<TCurlBindOptions> BindOptions;
};

IHttpClientPtr CreateCurlClient(TCurlClientOptions opts, NMonitoring::TMetricRegistry& registry);

} // namespace NSolomon
