#pragma once

#include <curl/curl.h>

namespace NSolomon {

inline TRequestError::EType FromCurlError(CURLcode result) {
    switch (result) {
        case CURLE_WRITE_ERROR:
            return TRequestError::EType::ResponseTooLarge;
        case CURLE_UNSUPPORTED_PROTOCOL:
            return TRequestError::EType::UnsupportedProtocol;
        case CURLE_URL_MALFORMAT:
            return TRequestError::EType::UrlMalformat;
        case CURLE_COULDNT_CONNECT:
            return TRequestError::EType::ConnectFailed;
        case CURLE_COULDNT_RESOLVE_HOST:
            return TRequestError::EType::DnsFailure;
        case CURLE_SEND_ERROR:
        case CURLE_RECV_ERROR:
            return TRequestError::EType::SocketError;
        case CURLE_OPERATION_TIMEDOUT:
            return TRequestError::EType::ReadTimeout;
        default:
            return TRequestError::EType::Unknown;
    }
}

} // namespace NSolomon
