#pragma once

#include <util/generic/ptr.h>

#include <curl/curl.h>

namespace NSolomon {

struct ICurlHandle {
    virtual ~ICurlHandle() = default;

    explicit ICurlHandle(CURL* handle) noexcept
        : Handle_{handle}
    {
    }

    CURL* Handle() const noexcept {
        return Handle_;
    }

protected:
    CURL* Handle_{nullptr};
};

} // namespace NSolomon
