#pragma once

#include "handle.h"

#include <library/cpp/monlib/metrics/fwd.h>

namespace NSolomon {

struct ICurlHandlePool {
    struct TStats {
        size_t TotalSize{0};
        size_t HandlesAvailable{0};
        size_t HandlesUsed{0};
    };

    virtual ~ICurlHandlePool() = default;

    virtual std::unique_ptr<ICurlHandle> GetHandle() = 0;

    virtual TStats Stats() const = 0;
};

std::unique_ptr<ICurlHandlePool> CreateHandlePool(NMonitoring::IMetricFactory& metrics);

} // namespace NSolomon
