#pragma once

#include <library/cpp/monlib/metrics/fwd.h>

#include <util/generic/ptr.h>
#include <util/datetime/base.h>

#include <curl/curl.h>

namespace NSolomon {

    // not thread-safe
    class TCurlSocketPoller {
    public:
        explicit TCurlSocketPoller(NMonitoring::IMetricFactory& metrics);
        ~TCurlSocketPoller();

        void AddWait(curl_socket_t sock, int what, void* cookie);
        void Unwait(curl_socket_t sock);

        size_t WaitD(void** events, int* filters, size_t len, TInstant deadline);

    private:
        struct TImpl;
        THolder<TImpl> Impl_;
    };

} // namespace NSolomon
